package spaceGame.request;

import java.io.IOException;

import spaceGame.User;

import core.response.GameResponse;

public class RequestQuiz extends GameRequest {
	
	// User object.
	private User user;
	
	// User id.
	private long userId;
	
	// See QUIZ_TYPE_* constants.
	private long quizType = -1;

	@Override
	public void parse() {
		try {
			userId = getData().readLong();
			quizType = getData().readLong();
		} catch ( IOException e ) {
			getServer().log( "RequestQuiz.parse: " + e.getMessage() );
		}
	}
	
	
	@Override
	public void run() {
		user = getServer().getSpaceUser( userId );
		if ( null == user ) {
			gs.log( "RequestQuiz.run(): invalid user." );
			return;
		}
		
		// Start quiz.
		user.startQuiz( quizType );
		
		// Send first question.
		try {
			GameResponse response = getServer().getSpaceDB().getQuizQuestionFor( user );
			response.set( getServer() );
			response.setOutputStream( getSocket().getOutputStream() );
			response.run();
			
		} catch ( IOException e ) {
			getServer().log( "RequestQuiz.run: " + e.getMessage() );
		}
	}
	
	/**
	 * Get user who requested quiz.
	 * @return
	 */
	public User getUser() {
		return user;
	}
	
	/**
	 * Get type of quiz.
	 * @return
	 */
	public long getQuizType() {
		return quizType;
	}

}
