package spaceGame.request;

import java.io.IOException;

import spaceGame.User;

public class RequestQuizEnd extends GameRequest {

	// User object.
	private long userId;

	@Override
	public void parse() {
		try {
			userId = getData().readLong();
		} catch ( IOException e ) {
			getServer().log( "RequestQuizEnd.parse(): " + e.getMessage() );
		}
		
	}
	
	
	@Override
	public void run() {
		User user = (spaceGame.User)getServer().getUser( userId );
		if ( null == user ) {
			gs.log( "RequestQuizEnd.run(): invalid user." );
			return;
		}
		
		// Set the user object back into normal mode.
		user.stopQuiz();
		
		// TODO: should send response here, I think(?)
		
	}

}
