package spaceGame.response;

import java.io.IOException;

import spaceGame.Constants;
import core.response.GameResponse;

/**
 * Sends a response about the correctness of the user's
 * answer to the quiz, competition, or exam question. 
 * @author eric
 */
public class ResponseAnswerCheck extends GameResponse {
	
	private boolean correct;
	
	/**
	 * Set whether or not the answer to the question was correct.
	 * @param correct
	 */
	public void setCorrect( boolean correct ) {
		this.correct = correct;
	}

	@Override
	public void run() {
		try {
			gs.debug( "Sending answer check response" );
			getData().writeInt( Constants.RESP_ANSWER_CHECK );
			getData().writeBoolean( correct );
		} catch (IOException e) {
			gs.log( e.getMessage() );
		}
		
	}

}
