package spaceGame.response;

import java.io.IOException;
import java.util.Vector;

import spaceGame.Constants;

public class ResponseQuestionChoice extends ResponseQuestion {
	
	// Choices for this question.
	private Vector<Choice> choices = new Vector<Choice>();
	
	/**
	 * Sets up an individual choice.
	 * @param id code for the choice (i.e. a, b, c...)
	 * @param msg text message of choice (i.e. "Pluto")
	 */
	public void addChoice( char id, String msg ) {
		Choice c = new Choice();
		c.id = id;
		c.msg = msg;
		choices.add( c );
	}

	@Override
	public void run() {
		try {
			gs.debug( "Sending question" );
			
			// Packet id.
			getData().writeInt( Constants.RESP_QUESTION_CHOICE );
			
			// Question.
			getData().writeUTF( getQuestionText() );
			gs.debug( "Question: " + getQuestionText() );
			
			// Number of choices.
			getData().writeInt( choices.size() );
			
			// Choices.
			for ( Choice c : choices ) {
				gs.debug( "Choice " + c.id + " : " + c.msg );
				getData().writeChar( c.id );
				getData().writeUTF( c.msg );
			}
			
		} catch (IOException e) {
			gs.log( e.getMessage() );
		}
	}
	
	// The choices we make!
	class Choice {
		public char id;
		public String msg;
	}

}
