package test;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import test.request.ClientRequestLogin;
import test.response.ClientResponseAuth;

/**
 * Tests the login function.
 * @author eric
 *
 */
public class TestLogin extends GameClient {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		//String host = "192.168.1.101";
		String host = "localhost";
		int port = 7654;
		
		try {
			System.out.println("Attempting to connect to server...");
			Socket socket = new Socket( host, port );
			System.out.println("...connected.  Logging in.");
			ClientRequestLogin login = new ClientRequestLogin();
			login.setSocket( socket );
			
			// Set values.
			login.setUsername( "MrEricSir" );
			login.setPassword( "pass" );
			
			// Execute.
			login.run();
			System.out.println("Login request sent.");
			
			// Run response.
			ClientResponseAuth auth = new ClientResponseAuth(); 
			auth.setSocket(	login.getSocket() );
			auth.run();
			
		} catch (UnknownHostException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		

	}

}
