package test.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;

public abstract class ClientRequest implements Runnable {
	
	// Request ID numbers.
	protected final long requestHeartbeat = 0;
	protected final long requestLogin = 1;
	protected final long requestLogout = 2;
	
	protected Socket socket = null;
	
	protected DataOutputStream data = null; 
	
	/**
	 * Must call this before run() with a valid
	 * client socket.
	 * @param s valid client socket.
	 * @throws IOException
	 */
	public void setSocket( Socket s ) throws IOException {
		socket = s;
		OutputStream out = socket.getOutputStream();
		data = new DataOutputStream( out );
	}
	
	public Socket getSocket() {
		return socket;
	}
	
	/**
	 * Executes the client request.
	 */
	public abstract void run();

}
