package test.response;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;

public abstract class ClientResponse implements Runnable {
	
	protected Socket socket = null;
	
	protected DataOutputStream data = null; 
	
	/**
	 * Must call this before run() with a valid
	 * client socket.
	 * @param s valid client socket.
	 * @throws IOException
	 */
	public void setSocket( Socket s ) throws IOException {
		socket = s;
		OutputStream out = socket.getOutputStream();
		data = new DataOutputStream( out );
	}
	
	/**
	 * Executes the client request.
	 */
	public abstract void run();

}
