package test.response;

import java.io.DataInputStream;
import java.io.InputStream;

import core.Constants;

public class ClientResponseAuth extends ClientResponse {
	
	long userID = -1;
	
	public long getUserId() {
		return userID;
	}

	@Override
	public void run() {
		try {
			// Get response.			
			InputStream in = socket.getInputStream();
			DataInputStream dataIn = new DataInputStream( in );			
	
			int id = dataIn.readInt();
			System.out.println("Response ID: " + id );
			if ( id == Constants.RESP_AUTH_OK ) {
				userID = dataIn.readLong();
				System.out.println("User ID: " + userID );
				
				// number of users, then data for each user.
				long numUsers = dataIn.readLong();
				System.out.println("# of users logged in: " + numUsers );
				for ( int i = 0; i < numUsers; i++ ) {
					System.out.println(i + ")");
					System.out.println("  User ID: " + dataIn.readLong() );
					System.out.println("  Username: " + dataIn.readUTF() );
					System.out.println("  Team ID: " + dataIn.readLong() );
					System.out.println("  Model ID: " + dataIn.readLong() );
				}
				
				// Info about all teams.
				long numTeams = dataIn.readLong();
				System.out.println("# of teams " + numTeams);
				for ( int i = 0; i < numTeams; i++ ) {
					System.out.println(i + ")");
					System.out.println("  Team ID: " + dataIn.readLong() ); // team id
					System.out.println("  Team name: " + dataIn.readUTF() ); // team name
					System.out.println("  Team color: " + dataIn.readLong() ); // team color
				}
				
				// Sector data.
				long sectorID = dataIn.readLong();
				System.out.println("Sector id " + sectorID );
				long numUsersInSector = dataIn.readLong();
				System.out.println("# of users in sector " + numUsersInSector);
				for ( int i = 0; i < numTeams; i++ ) {
					System.out.println(i + ")");
					System.out.println("  User ID: " + dataIn.readLong() );
					System.out.println("  X: " + dataIn.readLong() );
					System.out.println("  Y: " + dataIn.readLong() );
					System.out.println("  Z: " + dataIn.readLong() );
					System.out.println("  I: " + dataIn.readLong() );
					System.out.println("  J: " + dataIn.readLong() );
					System.out.println("  K: " + dataIn.readLong() );
					System.out.println("  isMoving: " + dataIn.readBoolean() );
				}
			} else {
				System.out.println("Could not login");
			}
		} catch ( Exception e ) {
			e.printStackTrace();
		}

	}

}
