package test.response;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

import core.Constants;

public class ClientResponseUpdate extends ClientResponse {

	@Override
	public void run() {
		// Get response.			
		InputStream in;
		DataInputStream dataIn;
		try {
			in = socket.getInputStream();
			dataIn = new DataInputStream( in );
			
			// Chew off type of response, not needed (yet) 
			// because we know what it is.
			dataIn.readInt();
			
			// Get the number of responses.
			long numResponses = dataIn.readLong();
			System.out.println("Number of update responsses: " + numResponses);
			
			for ( int i = 0; i < numResponses; i++ ) {
				int id = dataIn.readInt();
				System.out.println( i + ".");
				System.out.println("   Response Id: " + id);
				switch ( id ) {
					case Constants.RESP_CHAT_TEAM :
						long userId = dataIn.readLong();
						String message = dataIn.readUTF();
						System.out.println("   User " + userId + " says: " + message );
						break;
					// etc.
				
				}
			}
			
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		
	}

}
